/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util;

import java.io.IOException;

public class BitMap
implements Cloneable {
    private byte[] a;

    public BitMap() {
    }

    public BitMap(int n) {
        int n2 = n >> 3;
        int n3 = n & 7;
        if (n3 > 0) {
            ++n2;
        }
        this.a = new byte[n2];
    }

    public BitMap(byte[] byArray) {
        this.load(byArray);
    }

    public void set() {
        if (this.a == null) {
            throw new IOException("Bitmap does not allocated");
        }
        this.set(0, this.a.length << 3);
    }

    public void set(int n) {
        if (this.a == null) {
            throw new IOException("Bitmap does not allocated");
        }
        if (n > this.a.length << 3) {
            throw new IndexOutOfBoundsException("Pos " + n + " is invalid");
        }
        int n2 = n >> 3;
        int n3 = n & 7;
        this.a[n2] = (byte)(this.a[n2] | 1 << n3);
    }

    public void set(int n, int n2) {
        this.set(n, n2, true);
    }

    protected void set(int n, int n2, boolean bl) {
        BitMap.checkRange(n, n2);
        if (n == n2) {
            return;
        }
        int n3 = n >> 3;
        int n4 = n2 >> 3;
        int n5 = n2 & 7;
        if (n3 == n4) {
            for (var4_4 = n & 7; var4_4 < n5; ++var4_4) {
                this.a[n3] = bl ? (byte)(this.a[n3] | 1 << var4_4) : (byte)(this.a[n3] & ~(1 << var4_4));
            }
            ++n3;
        } else {
            while (var4_4 < 8) {
                this.a[n3] = bl ? (byte)(this.a[n3] | 1 << var4_4) : (byte)(this.a[n3] & ~(1 << var4_4));
                ++var4_4;
            }
            ++n3;
            if (n5 != 0) {
                for (int i = 0; i < n5; ++i) {
                    this.a[n4] = bl ? (byte)(this.a[n4] | 1 << i) : (byte)(this.a[n4] & ~(1 << i));
                }
            }
            --n4;
        }
        while (n3 <= n4) {
            this.a[n3] = bl ? -1 : 0;
            ++n3;
        }
    }

    public void clear() {
        if (this.a == null) {
            throw new IOException("Bitmap does not allocated");
        }
        this.clear(0, this.a.length << 3);
    }

    public void clear(int n) {
        if (this.a == null) {
            throw new IOException("Bitmap does not allocated");
        }
        if (n > this.a.length << 3) {
            throw new IndexOutOfBoundsException("Pos " + n + " is invalid");
        }
        int n2 = n >> 3;
        int n3 = n & 7;
        this.a[n2] = (byte)(this.a[n2] & ~(1 << n3));
    }

    public void clear(int n, int n2) {
        this.set(n, n2, false);
    }

    protected static void checkRange(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
    }

    public void printString() {
        if (this.a == null) {
            throw new IOException("Bitmap does not allocated");
        }
        for (byte by : this.a) {
            System.out.print(this.byteToString(by));
            System.out.print(" ");
        }
        System.out.println("");
    }

    public String byteToString(byte by) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            int n = 1 << i;
            stringBuilder.append((by & n) != 0 ? "1" : "0");
        }
        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "");
        return stringBuilder.toString();
    }

    public boolean get(int n) {
        if (this.a == null) {
            throw new IOException("Bitmap does not allocated");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Pos " + n + " is invalid");
        }
        int n2 = n >> 3;
        byte by = this.a[n2];
        int n3 = n & 7;
        int n4 = 1 << n3;
        return (by & n4) != 0;
    }

    public void print() {
        System.out.println("Output");
        for (int i = 0; i < this.size(); ++i) {
            System.out.println("i =" + i + ", " + (this.get(i) ? "1" : "0"));
        }
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = n >> 3;
        int n3 = n & 7;
        while (n2 < this.a.length) {
            byte by = this.a[n2];
            if (by != 0) {
                while (n3 < 8) {
                    int n4 = 1 << n3;
                    if ((by & n4) != 0) {
                        return (n2 << 3) + n3;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            ++n2;
        }
        return -1;
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = n >> 3;
        int n3 = n & 7;
        while (n2 < this.a.length) {
            byte by = this.a[n2];
            if ((by & 0xFF) != 255) {
                while (n3 < 8) {
                    int n4 = 1 << n3;
                    if ((by & n4) == 0) {
                        return (n2 << 3) + n3;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            ++n2;
        }
        return -1;
    }

    public static BitMap and(BitMap bitMap, BitMap bitMap2) {
        byte[] byArray = bitMap.a;
        byte[] byArray2 = bitMap2.a;
        if (byArray.length != byArray2.length) {
            throw new RuntimeException("Array sizes differ");
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] & byArray2[i]);
        }
        return new BitMap(byArray3);
    }

    public static BitMap or(BitMap bitMap, BitMap bitMap2) {
        byte[] byArray = bitMap.a;
        byte[] byArray2 = bitMap2.a;
        if (byArray.length != byArray2.length) {
            throw new RuntimeException("Array sizes differ");
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] | byArray2[i]);
        }
        return new BitMap(byArray3);
    }

    public static BitMap xor(BitMap bitMap, BitMap bitMap2) {
        byte[] byArray = bitMap.a;
        byte[] byArray2 = bitMap2.a;
        if (byArray.length != byArray2.length) {
            throw new RuntimeException("Array sizes differ");
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return new BitMap(byArray3);
    }

    public int size() {
        return this.a.length << 3;
    }

    public void load(byte[] byArray) {
        this.a = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.a, 0, byArray.length);
    }

    public byte[] toByteArray() {
        return this.a;
    }

    public boolean isEmpty() {
        for (byte by : this.a) {
            if (by == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return new BitMap(this.a);
    }

    public static void main(String[] stringArray) {
        BitMap bitMap = new BitMap(10);
        try {
            if (bitMap.isEmpty()) {
                System.out.println("BitMap is empty");
            }
            System.out.println("Next clear pos from 0 is " + bitMap.nextClearBit(0));
            bitMap.set(1);
            bitMap.set(2);
            bitMap.set(3);
            bitMap.set(4);
            bitMap.set(5);
            bitMap.set(6);
            bitMap.set(7);
            System.out.println("Next clear pos from 0 is " + bitMap.nextClearBit(1));
            bitMap.printString();
            if (bitMap.isEmpty()) {
                System.out.println("BitMap is empty");
            }
            bitMap.set(9);
            bitMap.printString();
            System.out.println("Next bit pos from 1 is " + bitMap.nextSetBit(1));
            System.out.println("Next clear pos from 1 is " + bitMap.nextClearBit(1));
            System.out.println("Next bit pos from 2 is " + bitMap.nextSetBit(2));
            if (bitMap.isEmpty()) {
                System.out.println("BitMap is empty");
            }
            bitMap.clear(1);
            bitMap.printString();
            System.out.println("Next bit pos from 1 is " + bitMap.nextSetBit(1));
            System.out.println("Next bit pos from 2 is " + bitMap.nextSetBit(2));
            bitMap.clear(9);
            bitMap.printString();
            if (bitMap.isEmpty()) {
                System.out.println("BitMap is empty");
            }
            bitMap.clear();
            bitMap.printString();
            if (bitMap.isEmpty()) {
                System.out.println("BitMap is empty");
            }
            bitMap.set();
            bitMap.printString();
            bitMap.clear(2, 5);
            bitMap.printString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

