/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.fsutil;

import com.ahsay.ani.fsutil.ChildFile;
import com.ahsay.ani.fsutil.FolderIteratorJava;
import com.ahsay.ani.fsutil.FolderIteratorMac;
import com.ahsay.ani.fsutil.FolderIteratorNix;
import com.ahsay.ani.fsutil.FolderIteratorWin;
import com.ahsay.ani.fsutil.NativeLibLoader;
import com.ahsay.ani.fsutil.Platform;
import java.util.Iterator;

public abstract class FolderIterator<T extends ChildFile>
implements Iterator<T> {
    public static final int LIST_OPTION_NONE = 0;
    public static final int LIST_OPTION_ALL = -1;
    protected static final String FI_DEBUG_PROPERTY = "com.ahsay.ani.fsutil.FolderIterator.debug";
    protected static final String FI_JAVA_ONLY_PROPERTY = "com.ahsay.ani.fsutil.FolderIterator.javaOnly";
    protected static final boolean FI_DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.ani.fsutil.FolderIterator.debug"));
    protected static final boolean JAVA_ONLY = "true".equalsIgnoreCase(System.getProperty("com.ahsay.ani.fsutil.FolderIterator.javaOnly"));
    protected static final boolean LOAD_NATIVE_LIB = true;
    protected final String PATH;
    protected Class<T> clsT;

    protected abstract Platform getPlatform();

    protected FolderIterator() {
        throw new RuntimeException("[FolderIterator.init] This constructor should never be called");
    }

    protected FolderIterator(String string, boolean bl, Class<T> clazz) {
        this.PATH = string;
        this.clsT = clazz;
        if (bl) {
            NativeLibLoader.loadLibrary();
        } else if (FI_DEBUG) {
            System.out.println("[FolderIterator.init] Using java File.listFiles() for " + string + " which loads all file objects into memory");
        }
    }

    public static FolderIterator<ChildFile> getInstance(String string) {
        return FolderIterator.getInstance(string, ChildFile.class);
    }

    public static <T extends ChildFile> FolderIterator<T> getInstance(String string, Class<T> clazz) {
        return FolderIterator.getInstance(string, false, clazz);
    }

    public static <T extends ChildFile> FolderIterator<T> getInstance(String string, boolean bl, Class<T> clazz) {
        if (JAVA_ONLY || bl) {
            return new FolderIteratorJava<T>(string, clazz);
        }
        if (NativeLibLoader.IS_SUPPORTED_WIN) {
            return new FolderIteratorWin<T>(string, clazz);
        }
        if (NativeLibLoader.IS_SUPPORTED_LIN || NativeLibLoader.IS_SUPPORTED_FBD || NativeLibLoader.IS_SUPPORTED_OBD || NativeLibLoader.IS_SUPPORTED_SOS || NativeLibLoader.IS_SUPPORTED_AIX) {
            return new FolderIteratorNix<T>(string, clazz);
        }
        if (NativeLibLoader.IS_SUPPORTED_MAC) {
            return new FolderIteratorMac<T>(string, clazz);
        }
        return new FolderIteratorJava<T>(string, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 1;
        long l = 0L;
        try {
            for (int i = 0; i < n; ++i) {
                long l2;
                System.out.println("[FolderIterator.main] Start");
                String string = stringArray[0];
                int n2 = 0;
                try (FolderIterator<ChildFile> folderIterator = FolderIterator.getInstance(string);){
                    l2 = System.currentTimeMillis();
                    while (folderIterator.hasNext()) {
                        ChildFile childFile = (ChildFile)folderIterator.next();
                        System.out.println("[FolderIterator.main] " + childFile.getPath() + ", lastModified=" + childFile.getLastModified() + ", changeTime=" + childFile.getChangeTimeNative() + ", size=" + childFile.getSize() + ", efs=" + childFile.isEfs() + ", link=" + childFile.isLink());
                        try {
                            if (childFile.isDirectory()) {
                                try (FolderIterator<ChildFile> folderIterator2 = FolderIterator.getInstance(childFile.getPath());){
                                    while (folderIterator2.hasNext()) {
                                        ChildFile childFile2 = (ChildFile)folderIterator2.next();
                                        System.out.println("[FolderIterator.main] " + childFile2.getPath() + ", lastModified=" + childFile2.getLastModified() + ", changeTime=" + childFile.getChangeTimeNative() + ", size=" + childFile2.getSize() + ", efs=" + childFile2.isEfs() + ", link=" + childFile2.isLink());
                                        ++n2;
                                    }
                                }
                            }
                            ++n2;
                        }
                        catch (Exception exception) {
                            System.out.println("[FolderIterator.main] *************** Failed to list " + childFile.getPath() + ", Error=" + exception.getMessage());
                        }
                    }
                }
                System.out.println("[FolderIterator.main] End");
                System.out.println("[FolderIterator.main] Number of files/directories = " + n2);
                long l3 = System.currentTimeMillis() - l2;
                l += l3;
                System.out.println("[FolderIterator.main] Time elapsed " + l3 + "ms");
            }
            if (n > 1) {
                System.out.println("[FolderIterator.main] Total Time elapsed " + l + "ms");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public abstract void close();

    public String getPath() {
        return this.PATH;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("[FolderIterator.remove] not supported");
    }
}

