/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani;

import com.ahsay.ani.SystemInfo$1;
import com.ahsay.ani.console.LineCommand;
import com.ahsay.ani.console.LineCommand$Output;
import com.ahsay.ani.util.IConstants;
import com.ahsay.ani.util.LocationConstants;
import com.ahsay.ani.util.MacUtil;
import com.ahsay.ani.util.NasUtil;
import com.ahsay.ani.util.QnapUtil;
import com.ahsay.ani.util.StringUtil;
import com.ahsay.ani.util.SynologyUtil;
import com.ahsay.ani.util.WindowsUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemInfo
implements IConstants {
    public static final String NEW_LINE;
    public static final String JAVA_VENDOR;
    public static final String JAVA_HOME;
    public static final boolean IS_SUN_JVM;
    public static final boolean IS_IBM_JVM;
    public static final String JAVA_VERSION;
    public static final boolean IS_JVM_11;
    public static final boolean IS_JVM_12;
    public static final boolean IS_JVM_13;
    public static final boolean IS_JVM_14;
    public static final boolean IS_JVM_15;
    public static final boolean IS_JVM_16;
    public static final boolean IS_JVM_17;
    public static final boolean IS_JVM_18;
    public static final String USER_NAME;
    public static final String SUN_CPU_ISALIST;
    public static final String OS_ARCH;
    public static final String OS_PATCH_LEVEL;
    public static final boolean IS_OS_ARCH_I386;
    public static final boolean IS_OS_ARCH_AMD64;
    public static final boolean IS_OS_ARCH_X86_64;
    public static final boolean IS_OS_ARCH_X86;
    public static final boolean IS_OS_ARCH_X64;
    public static final boolean IS_OS_ARCH_PPC;
    public static final boolean IS_OS_ARCH_PPC64;
    public static final boolean IS_OS_ARCH_IA64;
    public static final boolean IS_OS_ARCH_ARM;
    public static final boolean IS_OS_ARCH_AARCH64;
    public static final boolean IS_OS_ARCH_SPARC;
    public static final boolean IS_OS_ARCH_SPARCV9;
    public static final boolean IS_64BIT_JVM;
    public static final String USER_HOME;
    public static final String USER_WORKING_DIR;
    protected static final String JAVA_OS_NAME;
    protected static final String JAVA_OS_VERSION;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_WIN95;
    public static final boolean IS_WIN98;
    public static final boolean IS_WINME;
    public static final boolean IS_WIN9XME;
    public static final boolean IS_WINNT;
    public static final boolean IS_WIN2000;
    public static final boolean IS_WINXP;
    public static final boolean IS_WIN_NT_2K_XP;
    public static final boolean IS_WIN2003;
    public static final WindowsUtil winUtil;
    public static final MacUtil macUtil;
    public static final NasUtil nasUtil;
    public static final int LOCATION_ID;
    public static final String VMWARE_TOOLS_PATH_WINDOWS = "C:\\Program Files\\VMware\\VMware Tools\\VMwareToolboxCmd.exe";
    public static final String VMWARE_TOOLS_PATH_MAC = "/Library/Application Support/VMware Tools/vmware-tools-cli";
    public static final String VMWARE_TOOLS_PATH_LINUX_SOLARIS = "/usr/sbin/vmware-toolbox-cmd";
    public static final String VMWARE_TOOLS_PATH_FREEBSD = "/usr/local/sbin/vmware-toolbox-cmd";
    public static final int WIN_VER_NT_WORKSTATION = 1;
    public static final int WIN_VER_NT_DOMAIN_CONTROLLER = 2;
    public static final int WIN_VER_NT_SERVER = 3;
    public static final int WIN_PRODUCT_TYPE;
    public static final boolean IS_WIN_WORKSTATION_PRODUCT_TYPE;
    public static final long WINDOWS_MAJOR_VERSION;
    public static final long WINDOWS_MINOR_VERSION;
    public static final long WINDOWS_BUILD_MAJOR_VERSION;
    public static final long WINDOWS_BUILD_MINOR_VERSION;
    public static final String WINDOWS_OS_FULL_VERSION;
    public static final String MAC_OS_VERSION;
    public static final String NIX_OS_KERNEL_VERSION;
    public static final String OS_VERSION;
    public static final String OS_KERNEL_VERSION;
    public static final String NAS_MODEL;
    public static final boolean IS_WIN_VER60_FAMILY;
    public static final boolean IS_WINVISTA;
    public static final boolean IS_WIN2008;
    public static final boolean IS_WIN_VER61_FAMILY;
    public static final boolean IS_WIN7;
    public static final boolean IS_WIN2008R2;
    public static final boolean IS_WIN2008_FAMILY;
    public static final boolean IS_WIN_VER62_FAMILY;
    public static final boolean IS_WIN8;
    public static final boolean IS_WIN2012;
    public static final boolean IS_WIN_VER63_FAMILY;
    public static final boolean IS_WIN81;
    public static final boolean IS_WIN2012R2;
    public static final boolean IS_WIN2012_FAMILY;
    public static final boolean IS_WIN_VER100_FAMILY;
    public static final boolean IS_WIN10;
    public static final boolean IS_WIN11;
    public static final boolean IS_WIN2016;
    public static final boolean IS_WIN2019;
    public static final boolean IS_WIN2022;
    public static final boolean IS_WIN2025;
    public static final String OS_NAME;
    public static final boolean IS_NTFS5_OS;
    public static final boolean IS_VSS_OS;
    public static final boolean IS_NAS;
    public static final String JAVA_AWT_HEADLESS;
    public static boolean IS_AWT_HEADLESS;
    public static boolean IS_AHSAYUBS;
    protected static final String UBS_ID = "UBS";
    public static final String AFC_OPT_FILENAME = "afc.opt";
    public static final boolean IS_MAC;
    public static final boolean IS_MAC_10_2;
    public static final boolean IS_MAC_10_3;
    public static final boolean IS_MAC_10_4;
    public static final boolean IS_MAC_10_5;
    public static final boolean IS_NETWARE;
    public static final boolean IS_FREEBSD;
    public static final boolean IS_OPENBSD;
    public static final boolean IS_NETBSD;
    public static final boolean IS_LINUX;
    public static final boolean IS_SOLARIS;
    public static final boolean IS_SUN_OS;
    public static final boolean IS_AIX;
    public static final boolean IS_HPUX;
    public static final boolean IS_SCO;
    public static final boolean IS_UNIXWARE;
    public static final boolean IS_UNIX;
    public static final boolean IS_LINUX_RELATED;
    public static final String LOCALHOST = "localhost";
    public static final String LOCALHOST_LOCALDOMAIN = "localhost.localdomain";
    public static final String LOOPBACKUP_IPv4_ADDRESS = "127.0.0.1";
    public static final String LOOPBACKUP_IPv6_ADDRESS = "0:0:0:0:0:0:0:1";
    public static final String DEBUG_TRUE = "true";
    public static final String DEBUG_FALSE = "false";
    public static final String OS_FULL_NAME;
    public static final String LINE_SEPARATOR;
    private static String a;
    private static String b;

    public static boolean isWindows(String string) {
        return string != null && string.startsWith("Windows");
    }

    public static boolean isMac(String string) {
        return string != null && string.startsWith("Mac");
    }

    public static boolean isNetware(String string) {
        return string != null && string.startsWith("NetWare");
    }

    public static boolean isLinux(String string) {
        return string != null && string.startsWith("Linux");
    }

    public static boolean isFreeBSD(String string) {
        return string != null && string.startsWith("FreeBSD");
    }

    public static boolean isOpenBSD(String string) {
        return string != null && string.startsWith("OpenBSD");
    }

    public static boolean isNetBSD(String string) {
        return string != null && string.startsWith("NetBSD");
    }

    public static boolean isSolaris(String string) {
        return string != null && string.startsWith("Solaris");
    }

    public static boolean isSunOS(String string) {
        return string != null && string.startsWith("SunOS");
    }

    public static boolean isAIX(String string) {
        return string != null && string.startsWith("AIX");
    }

    public static boolean isHPUX(String string) {
        return string != null && string.startsWith("HP-UX");
    }

    public static boolean isUnixware(String string) {
        return string != null && string.startsWith("UNIX_SV");
    }

    public static boolean isSCO(String string) {
        return string != null && string.startsWith("OpenServer");
    }

    public static boolean isUnix(String string) {
        return string != null && (string.startsWith("Unix") || SystemInfo.isSolaris(string) || SystemInfo.isSunOS(string) || SystemInfo.isAIX(string) || SystemInfo.isHPUX(string) || SystemInfo.isUnixware(string) || SystemInfo.isSCO(string));
    }

    public static boolean isLinuxRelated(String string) {
        return SystemInfo.isLinux(string) || SystemInfo.isUnix(string) || SystemInfo.isFreeBSD(string) || SystemInfo.isOpenBSD(string) || SystemInfo.isNetBSD(string);
    }

    public static boolean isWindowsSystemBackupSupported() {
        try {
            return IS_WINDOWS && Float.parseFloat(OS_VERSION) >= 6.0f;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final synchronized String getLocalhostName() {
        String string;
        Object object;
        String[] stringArray;
        block19: {
            Object object2;
            if (a != null) {
                return a;
            }
            if (IS_MAC) {
                try {
                    stringArray = new String[]{"scutil", "--get", "LocalHostName"};
                    object = Runtime.getRuntime().exec(stringArray);
                    object2 = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                    try {
                        string = ((BufferedReader)object2).readLine();
                        if (string != null && !"".equals(string = string.trim())) {
                            String string2 = a = string;
                            return string2;
                        }
                    }
                    finally {
                        ((BufferedReader)object2).close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("[SystemInfo.getLocalhostName] Unable to obtain host name from 'hostname' on Mac OS X");
                    iOException.printStackTrace();
                }
            }
            try {
                if (!IS_LINUX_RELATED) break block19;
                stringArray = new String[]{"hostname"};
                object = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(stringArray).getInputStream()));
                try {
                    object2 = ((BufferedReader)object).readLine();
                    if (object2 != null) {
                        string = a = object2;
                        return string;
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        a = LOCALHOST;
        try {
            stringArray = InetAddress.getLocalHost();
            object = InetAddress.getAllByName(stringArray.getHostName());
            int i = 0;
            while (object != null) {
                if (i >= ((InetAddress[])object).length) return a;
                string = object[i].getHostName();
                if (!(string == null || "".equals(string = string.trim()) || LOCALHOST.equals(string) || LOCALHOST_LOCALDOMAIN.equals(string))) {
                    a = string;
                    if (!((InetAddress)object[i]).isLoopbackAddress()) return a;
                }
                ++i;
            }
            return a;
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return a;
    }

    public static synchronized void setLocalhostName(String string) {
        a = string;
    }

    public static final synchronized String getLocalhostIP() {
        if (b != null) {
            return b;
        }
        String string = SystemInfo.getLocalhostIPv4();
        if ("".equals(string)) {
            string = SystemInfo.getLocalhostIPv6();
        }
        b = string;
        return b;
    }

    private static synchronized ArrayList<NetworkInterface> a() {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
        Collections.sort(arrayList, new SystemInfo$1());
        return arrayList;
    }

    public static final synchronized String getLocalhostIPv4() {
        try {
            ArrayList<NetworkInterface> arrayList = SystemInfo.a();
            for (NetworkInterface networkInterface : arrayList) {
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return LOOPBACKUP_IPv4_ADDRESS;
    }

    public static final synchronized String getLocalhostIPv6() {
        try {
            ArrayList<NetworkInterface> arrayList = SystemInfo.a();
            for (NetworkInterface networkInterface : arrayList) {
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (!(inetAddress instanceof Inet6Address) || inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return LOOPBACKUP_IPv6_ADDRESS;
    }

    public static final String getNativeLibName(String object) {
        if (IS_WINDOWS) {
            object = (String)object + "Win";
        } else if (IS_LINUX) {
            object = (String)object + "Lin";
        } else if (IS_MAC) {
            object = (String)object + "Mac";
        } else if (IS_FREEBSD) {
            object = (String)object + "Fbd";
        } else if (IS_OPENBSD) {
            object = (String)object + "Obd";
        } else if (IS_SUN_OS) {
            object = (String)object + "Sos";
        } else if (IS_HPUX) {
            object = (String)object + "Hpx";
        } else if (IS_AIX) {
            object = (String)object + "Aix";
        } else {
            throw new SecurityException("[SystemInfo.getNixNativeLibName] Unable to find a supported operating system (os.name='" + OS_NAME + "' os.arch='" + OS_ARCH + "')");
        }
        if (IS_MAC) {
            object = (String)object + "All";
        } else if (IS_OS_ARCH_PPC) {
            object = (String)object + "Ppc";
        } else if (IS_OS_ARCH_PPC64) {
            object = (String)object + "P64";
        } else if (IS_OS_ARCH_IA64) {
            object = (String)object + "I64";
        } else if (IS_OS_ARCH_X64) {
            object = (String)object + "X64";
        } else if (IS_OS_ARCH_X86) {
            object = (String)object + "X86";
        } else if (IS_OS_ARCH_AARCH64) {
            object = (String)object + "A64";
        } else if (IS_OS_ARCH_ARM) {
            object = SynologyUtil.IS_SUPPORTED && nasUtil instanceof SynologyUtil && "6281".equals(((SynologyUtil)nasUtil).getPlatform()) ? (String)object + "Arm" : (String)object + "Ahf";
        } else if (IS_OS_ARCH_SPARCV9) {
            object = (String)object + "Sp9";
        } else if (IS_OS_ARCH_SPARC) {
            object = (String)object + "Spc";
        } else {
            throw new SecurityException("[SystemInfo.getNixNativeLibName] Unable to find a supported CPU architecture (os.name='" + OS_NAME + "' os.arch='" + OS_ARCH + "')");
        }
        return object;
    }

    public static void main(String[] stringArray) {
        try {
            System.getProperties().list(System.out);
            System.out.println("");
            System.out.println("Committed Virtual Memory: " + SystemInfo.getCommittedVirtualMemorySize());
            System.out.println("Total Physical Memory: " + SystemInfo.getTotalPhysicalMemorySize());
            System.out.println("Free Physical Memory: " + SystemInfo.getFreePhysicalMemorySize());
            System.out.println("Total Swap Space: " + SystemInfo.getTotalSwapSpaceSize());
            System.out.println("Free Swap Space: " + SystemInfo.getFreeSwapSpaceSize());
            System.out.println("Max Heap Size: " + SystemInfo.getMaximumHeapSize());
            System.out.println("Current Heap Size: " + SystemInfo.getCurrentHeapSize());
            System.out.println("Live Threads: " + SystemInfo.getThreadCount());
            System.out.println("Peak Threads: " + SystemInfo.getPeakThreadCount());
            System.out.println("Daemon Threads: " + SystemInfo.getDaemonThreadCount());
            System.out.println("Total Threads Started: " + SystemInfo.getTotalStartedThreadCount());
            System.out.println("Virtual Machine Name: " + SystemInfo.getVmName());
            System.out.println("Virtual Machine Vendor: " + SystemInfo.getVmVendor());
            System.out.println("Virtual Machine Arguments: " + SystemInfo.getVmArguments());
            System.out.println("Class Path: " + SystemInfo.getClassPath());
            System.out.println("Library Path: " + SystemInfo.getLibraryPath());
            System.out.println("Boot Class Path: " + SystemInfo.getBootClassPath());
            System.out.println("Current System Cpu Usage " + SystemInfo.getSystemCpuLoad());
            System.out.println("Current Process Cpu Usage: " + SystemInfo.getProcessCpuLoad());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static int getNumberOfProcessors() {
        try {
            return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getNumberOfProcessors] Failed to obtain number of processors, error = " + throwable.getMessage());
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties properties, File file) {
        if (!file.exists()) {
            return;
        }
        Properties properties2 = new Properties();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            properties2.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            System.out.println("[SystemInfo.loadProperties] Fail to load properties from " + file.getAbsolutePath() + " Reason=" + iOException.getMessage());
            return;
        }
        for (Map.Entry entry : properties2.entrySet()) {
            String string = (String)entry.getValue();
            if (string == null || "".equals(string.trim())) continue;
            String string2 = (String)entry.getKey();
            properties.setProperty(string2, string);
        }
        properties2.clear();
    }

    public static long getMaximumHeapSize() {
        try {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getMaximumHeapSize] Failed to obtain maximum heap size, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static long getCurrentHeapSize() {
        try {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getCurrentHeapSize] Failed to obtain current heap size, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static long getCommittedVirtualMemorySize() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getCommittedVirtualMemorySize();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getCommittedVirtualMemorySize] Failed to obtain committed virtual memory, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static long getTotalPhysicalMemorySize() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalMemorySize();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getTotalPhysicalMemorySize] Failed to obtain total physical memory, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static long getFreePhysicalMemorySize() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreeMemorySize();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getFreePhysicalMemorySize] Failed to obtain free physical memory, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static long getTotalSwapSpaceSize() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalSwapSpaceSize();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getTotalSwapSpaceSize] Failed to obtain total swap space, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static long getFreeSwapSpaceSize() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreeSwapSpaceSize();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getFreeSwapSpaceSize] Failed to obtain free swap space, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static int getThreadCount() {
        try {
            return ManagementFactory.getThreadMXBean().getThreadCount();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getThreadCount] Failed to obtain the number of live threads, error = " + throwable.getMessage());
            return -1;
        }
    }

    public static int getPeakThreadCount() {
        try {
            return ManagementFactory.getThreadMXBean().getPeakThreadCount();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getPeakThreadCount] Failed to obtain the number of peak threads, error = " + throwable.getMessage());
            return -1;
        }
    }

    public static int getDaemonThreadCount() {
        try {
            return ManagementFactory.getThreadMXBean().getDaemonThreadCount();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getDaemonThreadCount] Failed to obtain the number of daemon threads, error = " + throwable.getMessage());
            return -1;
        }
    }

    public static long getTotalStartedThreadCount() {
        try {
            return ManagementFactory.getThreadMXBean().getTotalStartedThreadCount();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getTotalStartedThreadCount] Failed to obtain the number of total threads started, error = " + throwable.getMessage());
            return -1L;
        }
    }

    public static String getVmName() {
        try {
            return ManagementFactory.getRuntimeMXBean().getVmName();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getVmName] Failed to obtain the name of virtual machine, error = " + throwable.getMessage());
            return "";
        }
    }

    public static String getVmVersion() {
        try {
            return ManagementFactory.getRuntimeMXBean().getVmVersion();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getVmVersion] Failed to obtain the version of virtual machine, error = " + throwable.getMessage());
            return "";
        }
    }

    public static String getVmVendor() {
        try {
            return ManagementFactory.getRuntimeMXBean().getVmVendor();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getVmVendor] Failed to obtain the vendor of virtual machine, error = " + throwable.getMessage());
            return "";
        }
    }

    public static String getVmArguments() {
        Object object = "";
        try {
            List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String string : list) {
                object = (String)object + (!"".equals(object) ? " " : "") + string;
            }
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getVmArguments] Failed to obtain the input arguments of virtual machine, error = " + throwable.getMessage());
        }
        return object;
    }

    public static String getClassPath() {
        try {
            return ManagementFactory.getRuntimeMXBean().getClassPath();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getClassPath] Failed to obtain the class path, error = " + throwable.getMessage());
            return "";
        }
    }

    public static String getLibraryPath() {
        try {
            return ManagementFactory.getRuntimeMXBean().getLibraryPath();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getLibraryPath] Failed to obtain the library path, error = " + throwable.getMessage());
            return "";
        }
    }

    public static String getBootClassPath() {
        if (ManagementFactory.getRuntimeMXBean().isBootClassPathSupported()) {
            try {
                return ManagementFactory.getRuntimeMXBean().getBootClassPath();
            }
            catch (Throwable throwable) {
                System.out.println("[SystemInfo.getBootClassPath] Failed to obtain the boot class path, error = " + throwable.getMessage());
            }
        }
        return "";
    }

    public static double getSystemCpuLoad() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getCpuLoad();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getSystemCpuLoad] Failed to get System Cpu load, error = " + throwable.getMessage());
            return -1.0;
        }
    }

    public static double getProcessCpuLoad() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad();
        }
        catch (Throwable throwable) {
            System.out.println("[SystemInfo.getProcessCpuLoad] Failed to get Process Cpu load, error = " + throwable.getMessage());
            return -1.0;
        }
    }

    private static File b() {
        if (IS_WINDOWS) {
            return new File(VMWARE_TOOLS_PATH_WINDOWS);
        }
        if (IS_MAC) {
            return new File(VMWARE_TOOLS_PATH_MAC);
        }
        if (IS_LINUX || IS_SOLARIS) {
            return new File(VMWARE_TOOLS_PATH_LINUX_SOLARIS);
        }
        if (IS_FREEBSD) {
            return new File(VMWARE_TOOLS_PATH_FREEBSD);
        }
        return null;
    }

    public static String getVMToolsVersion() {
        File file = SystemInfo.b();
        if (file != null && file.exists()) {
            try {
                String[] stringArray = new String[]{file.getAbsolutePath(), "-v"};
                LineCommand$Output lineCommand$Output = LineCommand.execute(stringArray, null, new File(JAVA_HOME));
                Collection<String> collection = lineCommand$Output.getOutputMessages();
                if (collection != null && !collection.isEmpty()) {
                    for (String string : collection) {
                        if (string == null || "".equals(string.trim())) continue;
                        int n = string.indexOf("(");
                        if (n > 0) {
                            return string.substring(0, n).trim();
                        }
                        return string;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("[SystemInfo.getVMToolsVersion] Failed to obtain the VMware Tools version, error = " + exception.getMessage());
            }
        }
        return null;
    }

    public static String getMappedLibraryName(String string) {
        String string2 = System.mapLibraryName(string);
        if (string2 != null && string2.endsWith(".dylib")) {
            string2 = string2.replace(".dylib", ".jnilib");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block37: {
            Object object;
            Object object2;
            block36: {
                NEW_LINE = System.getProperty("line.separator");
                JAVA_VENDOR = System.getProperty("java.vendor");
                JAVA_HOME = System.getProperty("java.home");
                IS_SUN_JVM = JAVA_VENDOR != null && JAVA_VENDOR.startsWith("Sun");
                IS_IBM_JVM = JAVA_VENDOR != null && JAVA_VENDOR.toUpperCase().startsWith("IBM");
                JAVA_VERSION = System.getProperty("java.version");
                IS_JVM_11 = JAVA_VERSION.startsWith("1.1");
                IS_JVM_12 = JAVA_VERSION.startsWith("1.2");
                IS_JVM_13 = JAVA_VERSION.startsWith("1.3");
                IS_JVM_14 = JAVA_VERSION.startsWith("1.4");
                IS_JVM_15 = JAVA_VERSION.startsWith("1.5");
                IS_JVM_16 = JAVA_VERSION.startsWith("1.6");
                IS_JVM_17 = JAVA_VERSION.startsWith("1.7");
                IS_JVM_18 = JAVA_VERSION.startsWith("1.8");
                USER_NAME = System.getProperty("user.name");
                SUN_CPU_ISALIST = System.getProperty("sun.cpu.isalist");
                OS_ARCH = System.getProperty("os.arch");
                OS_PATCH_LEVEL = System.getProperty("sun.os.patch.level");
                IS_OS_ARCH_I386 = OS_ARCH != null && OS_ARCH.equals("i386");
                IS_OS_ARCH_AMD64 = OS_ARCH != null && OS_ARCH.equals("amd64");
                IS_OS_ARCH_X86_64 = OS_ARCH != null && OS_ARCH.equals("x86_64");
                IS_OS_ARCH_X86 = OS_ARCH != null && OS_ARCH.endsWith("86");
                IS_OS_ARCH_X64 = IS_OS_ARCH_AMD64 || IS_OS_ARCH_X86_64;
                IS_OS_ARCH_PPC = OS_ARCH != null && OS_ARCH.equals("ppc");
                IS_OS_ARCH_PPC64 = OS_ARCH != null && OS_ARCH.equals("ppc64");
                IS_OS_ARCH_IA64 = OS_ARCH != null && OS_ARCH.toLowerCase().startsWith("ia64");
                IS_OS_ARCH_ARM = OS_ARCH != null && OS_ARCH.startsWith("arm");
                IS_OS_ARCH_AARCH64 = OS_ARCH != null && OS_ARCH.startsWith("aarch64");
                IS_OS_ARCH_SPARC = OS_ARCH != null && OS_ARCH.startsWith("sparc");
                IS_OS_ARCH_SPARCV9 = OS_ARCH != null && OS_ARCH.startsWith("sparcv9") || SUN_CPU_ISALIST != null && SUN_CPU_ISALIST.indexOf("sparcv9") != -1;
                IS_64BIT_JVM = IS_OS_ARCH_AMD64 || IS_OS_ARCH_SPARCV9 || IS_OS_ARCH_X86_64 || IS_OS_ARCH_PPC64 || IS_OS_ARCH_IA64 || IS_OS_ARCH_AARCH64;
                USER_HOME = System.getProperty("user.home");
                USER_WORKING_DIR = System.getProperty("user.dir");
                JAVA_OS_NAME = System.getProperty("os.name");
                JAVA_OS_VERSION = System.getProperty("os.version");
                IS_WINDOWS = SystemInfo.isWindows(JAVA_OS_NAME);
                IS_WIN95 = IS_WINDOWS && JAVA_OS_NAME.indexOf("95") != -1;
                IS_WIN98 = IS_WINDOWS && JAVA_OS_NAME.indexOf("98") != -1;
                IS_WINME = IS_WINDOWS && JAVA_OS_NAME.indexOf("Me") != -1;
                IS_WIN9XME = IS_WIN95 || IS_WIN98 || IS_WINME;
                IS_WINNT = IS_WINDOWS && JAVA_OS_NAME.indexOf("NT") != -1 && !JAVA_OS_VERSION.startsWith("6");
                IS_WIN2000 = IS_WINDOWS && JAVA_OS_NAME.indexOf("2000") != -1;
                IS_WINXP = IS_WINDOWS && JAVA_OS_NAME.indexOf("XP") != -1;
                IS_WIN_NT_2K_XP = IS_WINNT || IS_WIN2000 || IS_WINXP;
                IS_WIN2003 = IS_WINDOWS && JAVA_OS_NAME.indexOf("2003") != -1;
                winUtil = WindowsUtil.IS_SUPPORTED ? new WindowsUtil() : null;
                MacUtil macUtil = SystemInfo.macUtil = MacUtil.IS_SUPPORTED ? new MacUtil() : null;
                nasUtil = SynologyUtil.IS_SUPPORTED ? new SynologyUtil() : (QnapUtil.IS_SUPPORTED ? new QnapUtil() : null);
                int n = -1;
                try {
                    if (winUtil != null) {
                        n = winUtil.getLocationID();
                    } else if (SystemInfo.macUtil != null) {
                        n = SystemInfo.macUtil.getLocationID();
                    } else if (nasUtil != null) {
                        if (LocationConstants.NAS_TO_WINDOWS_LOCATION_MAP.containsKey(nasUtil.getClockZone())) {
                            n = LocationConstants.NAS_TO_WINDOWS_LOCATION_MAP.get(nasUtil.getClockZone());
                        }
                    } else {
                        object2 = TimeZone.getDefault().getID();
                        if (LocationConstants.TIME_ZONE_TO_WINDOWS_LOCATION_MAP.containsKey(object2)) {
                            n = LocationConstants.TIME_ZONE_TO_WINDOWS_LOCATION_MAP.get(object2);
                        }
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    unsatisfiedLinkError.printStackTrace();
                }
                LOCATION_ID = n;
                WIN_PRODUCT_TYPE = winUtil != null ? winUtil.getProductType() : -1;
                IS_WIN_WORKSTATION_PRODUCT_TYPE = WIN_PRODUCT_TYPE == 1;
                long l = winUtil != null ? winUtil.getMajorVersion() : -1L;
                long l2 = winUtil != null ? winUtil.getMinorVersion() : -1L;
                long l3 = -1L;
                long l4 = -1L;
                try {
                    LineCommand$Output lineCommand$Output;
                    Collection<String> collection;
                    if (l <= 6L && (l != 6L || l2 < 2L) || (collection = (lineCommand$Output = LineCommand.execute("ver", null, (File)(object = new File(JAVA_HOME)))).getOutputMessages()) == null || collection.isEmpty()) break block36;
                    for (String string : collection) {
                        String[] stringArray;
                        Pattern pattern;
                        Matcher matcher;
                        if (string == null || "".equals(string.trim()) || !(matcher = (pattern = Pattern.compile("\\d+.\\d+.")).matcher(string)).find() || (stringArray = StringUtil.split(string.substring(matcher.start()), ".")).length < 2) continue;
                        l = Long.parseLong(stringArray[0]);
                        l2 = Long.parseLong(stringArray[1]);
                        if (stringArray.length >= 3) {
                            String string2 = StringUtil.rTrim(stringArray[2], "]");
                            l3 = Long.parseLong(string2);
                            if (stringArray.length >= 4) {
                                String string3 = StringUtil.rTrim(stringArray[3], "]");
                                l4 = Long.parseLong(string3);
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    WINDOWS_MAJOR_VERSION = l;
                    WINDOWS_MINOR_VERSION = l2;
                    WINDOWS_BUILD_MAJOR_VERSION = l3;
                    WINDOWS_BUILD_MINOR_VERSION = l4;
                    object = WINDOWS_MAJOR_VERSION + "." + WINDOWS_MINOR_VERSION;
                    if (WINDOWS_BUILD_MAJOR_VERSION >= 0L) {
                        object = (String)object + "." + WINDOWS_BUILD_MAJOR_VERSION;
                    }
                    if (WINDOWS_BUILD_MINOR_VERSION >= 0L) {
                        object = (String)object + "." + WINDOWS_BUILD_MINOR_VERSION;
                    }
                    WINDOWS_OS_FULL_VERSION = object;
                }
            }
            String string = null;
            object2 = null;
            try {
                LineCommand$Output lineCommand$Output;
                Collection<String> collection;
                File file = new File(JAVA_HOME);
                if (macUtil != null) {
                    LineCommand$Output lineCommand$Output2 = LineCommand.execute("/usr/bin/sw_vers -productVersion", null, file);
                    Collection<String> collection2 = lineCommand$Output2.getOutputMessages();
                    if (collection2 == null || collection2.isEmpty()) break block37;
                    Pattern pattern = Pattern.compile("\\d+.\\d+");
                    for (String string4 : collection2) {
                        if (string4 == null || "".equals(string4.trim()) || !((Matcher)(object = pattern.matcher(string4))).find()) continue;
                        string = ((Matcher)object).group(0);
                        break block37;
                    }
                    break block37;
                }
                if (SystemInfo.isAIX(System.getProperty("os.name"))) {
                    object2 = "5";
                } else if ((SynologyUtil.IS_SUPPORTED || QnapUtil.IS_SUPPORTED || SystemInfo.isLinux(System.getProperty("os.name"))) && (collection = (lineCommand$Output = LineCommand.execute("uname -r", null, file)).getOutputMessages()) != null && !collection.isEmpty()) {
                    for (String string5 : collection) {
                        String string6 = string5.trim();
                        object = string6.split("-");
                        object2 = object[0];
                    }
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                MAC_OS_VERSION = string;
                NIX_OS_KERNEL_VERSION = object2;
            }
        }
        if (WINDOWS_MAJOR_VERSION != -1L && WINDOWS_MINOR_VERSION != -1L) {
            OS_KERNEL_VERSION = OS_VERSION = Float.toString((float)WINDOWS_MAJOR_VERSION + (float)WINDOWS_MINOR_VERSION / 10.0f);
        } else if (nasUtil != null) {
            OS_VERSION = nasUtil.getOSVersion();
            OS_KERNEL_VERSION = NIX_OS_KERNEL_VERSION;
        } else if (MAC_OS_VERSION != null) {
            OS_KERNEL_VERSION = OS_VERSION = MAC_OS_VERSION;
        } else {
            OS_VERSION = JAVA_OS_VERSION;
            OS_KERNEL_VERSION = NIX_OS_KERNEL_VERSION;
        }
        NAS_MODEL = nasUtil != null ? nasUtil.getModel() : "";
        IS_WIN_VER60_FAMILY = IS_WINDOWS && "6.0".equals(OS_VERSION);
        IS_WINVISTA = IS_WIN_VER60_FAMILY && IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN2008 = IS_WIN_VER60_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN_VER61_FAMILY = IS_WINDOWS && "6.1".equals(OS_VERSION);
        IS_WIN7 = IS_WIN_VER61_FAMILY && IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN2008R2 = IS_WIN_VER61_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN2008_FAMILY = IS_WIN2008 || IS_WIN2008R2;
        IS_WIN_VER62_FAMILY = IS_WINDOWS && "6.2".equals(OS_VERSION);
        IS_WIN8 = IS_WIN_VER62_FAMILY && IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN2012 = IS_WIN_VER62_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN_VER63_FAMILY = IS_WINDOWS && "6.3".equals(OS_VERSION);
        IS_WIN81 = IS_WIN_VER63_FAMILY && IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN2012R2 = IS_WIN_VER63_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE;
        IS_WIN2012_FAMILY = IS_WIN2012 || IS_WIN2012R2;
        IS_WIN_VER100_FAMILY = IS_WINDOWS && "10.0".equals(OS_VERSION);
        IS_WIN10 = IS_WIN_VER100_FAMILY && IS_WIN_WORKSTATION_PRODUCT_TYPE && (WINDOWS_BUILD_MAJOR_VERSION == -1L || WINDOWS_BUILD_MAJOR_VERSION < 22000L);
        IS_WIN11 = IS_WIN_VER100_FAMILY && IS_WIN_WORKSTATION_PRODUCT_TYPE && WINDOWS_BUILD_MAJOR_VERSION != -1L && WINDOWS_BUILD_MAJOR_VERSION >= 22000L;
        IS_WIN2016 = IS_WIN_VER100_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE && (WINDOWS_BUILD_MAJOR_VERSION == -1L || WINDOWS_BUILD_MAJOR_VERSION < 17763L);
        IS_WIN2019 = IS_WIN_VER100_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE && WINDOWS_BUILD_MAJOR_VERSION != -1L && WINDOWS_BUILD_MAJOR_VERSION >= 17763L && WINDOWS_BUILD_MAJOR_VERSION < 20348L;
        IS_WIN2022 = IS_WIN_VER100_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE && WINDOWS_BUILD_MAJOR_VERSION != -1L && WINDOWS_BUILD_MAJOR_VERSION >= 20348L && WINDOWS_BUILD_MAJOR_VERSION < 26100L;
        boolean bl = IS_WIN2025 = IS_WIN_VER100_FAMILY && !IS_WIN_WORKSTATION_PRODUCT_TYPE && WINDOWS_BUILD_MAJOR_VERSION != -1L && WINDOWS_BUILD_MAJOR_VERSION >= 26100L;
        OS_NAME = IS_WIN7 ? "Windows 7" : (IS_WIN2008R2 ? "Windows Server 2008 R2" : (IS_WIN8 ? "Windows 8" : (IS_WIN2012 ? "Windows Server 2012" : (IS_WIN81 ? "Windows 8.1" : (IS_WIN2012R2 ? "Windows Server 2012 R2" : (IS_WIN10 ? "Windows 10" : (IS_WIN2016 ? "Windows Server 2016" : (IS_WIN2019 ? "Windows Server 2019" : (IS_WIN2022 ? "Windows Server 2022" : (IS_WIN2025 ? "Windows Server 2025" : (IS_WIN11 ? "Windows 11" : (nasUtil != null ? nasUtil.getOSName() : JAVA_OS_NAME))))))))))));
        IS_NTFS5_OS = IS_WINDOWS && !IS_WIN9XME && !IS_WINNT;
        IS_VSS_OS = IS_WINDOWS && !IS_WIN9XME && !IS_WINNT && !IS_WIN2000;
        IS_NAS = SynologyUtil.IS_SUPPORTED || QnapUtil.IS_SUPPORTED;
        JAVA_AWT_HEADLESS = System.getProperty("java.awt.headless");
        IS_AWT_HEADLESS = false;
        IS_AHSAYUBS = false;
        IS_MAC = SystemInfo.isMac(OS_NAME);
        IS_MAC_10_2 = IS_MAC && OS_VERSION.startsWith("10.2");
        IS_MAC_10_3 = IS_MAC && OS_VERSION.startsWith("10.3");
        IS_MAC_10_4 = IS_MAC && OS_VERSION.startsWith("10.4");
        IS_MAC_10_5 = IS_MAC && OS_VERSION.startsWith("10.5");
        IS_NETWARE = SystemInfo.isNetware(OS_NAME);
        IS_FREEBSD = SystemInfo.isFreeBSD(OS_NAME);
        IS_OPENBSD = SystemInfo.isOpenBSD(OS_NAME);
        IS_NETBSD = SystemInfo.isNetBSD(OS_NAME);
        IS_LINUX = IS_NAS || SystemInfo.isLinux(OS_NAME);
        IS_SOLARIS = SystemInfo.isSolaris(OS_NAME);
        IS_SUN_OS = SystemInfo.isSunOS(OS_NAME);
        IS_AIX = SystemInfo.isAIX(OS_NAME);
        IS_HPUX = SystemInfo.isHPUX(OS_NAME);
        IS_SCO = SystemInfo.isSCO(OS_NAME);
        IS_UNIXWARE = SystemInfo.isUnixware(OS_NAME);
        IS_UNIX = SystemInfo.isUnix(OS_NAME);
        IS_LINUX_RELATED = IS_NAS || SystemInfo.isLinuxRelated(OS_NAME);
        OS_FULL_NAME = IS_WINDOWS ? OS_NAME : OS_NAME + " " + OS_VERSION;
        LINE_SEPARATOR = System.getProperty("line.separator");
        a = null;
        b = null;
    }
}

