/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentIdentity;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepositoryWrapper;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class UserAuthPublicKey
extends UserAuth {
    UserAuthPublicKey() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(Session session) throws Exception {
        Vector<Identity> identities;
        super.start(session);
        Vector<Identity> vector = identities = session.getIdentityRepository().getIdentities();
        synchronized (vector) {
            List<String> pkmethods;
            String[] not_available_pka;
            List<String> not_available_pks;
            if (identities.size() <= 0) {
                return false;
            }
            String pkmethodstr = session.getConfig("PubkeyAcceptedAlgorithms");
            if (session.getLogger().isEnabled(0)) {
                session.getLogger().log(0, "PubkeyAcceptedAlgorithms = " + pkmethodstr);
            }
            List<String> list = not_available_pks = (not_available_pka = session.getUnavailableSignatures()) != null && not_available_pka.length > 0 ? Arrays.asList(not_available_pka) : Collections.emptyList();
            if (!not_available_pks.isEmpty() && session.getLogger().isEnabled(0)) {
                session.getLogger().log(0, "Signature algorithms unavailable for non-agent identities = " + String.valueOf(not_available_pks));
            }
            if ((pkmethods = Arrays.asList(Util.split(pkmethodstr, ","))).isEmpty()) {
                return false;
            }
            String[] server_sig_algs = session.getServerSigAlgs();
            if (server_sig_algs != null && server_sig_algs.length > 0) {
                ArrayList<String> _known = new ArrayList<String>();
                ArrayList<String> _unknown = new ArrayList<String>();
                for (String pkmethod : pkmethods) {
                    boolean add = false;
                    for (String server_sig_alg : server_sig_algs) {
                        if (!pkmethod.equals(server_sig_alg)) continue;
                        add = true;
                        break;
                    }
                    if (add) {
                        _known.add(pkmethod);
                        continue;
                    }
                    _unknown.add(pkmethod);
                }
                if (!_known.isEmpty() && session.getLogger().isEnabled(0)) {
                    session.getLogger().log(0, "PubkeyAcceptedAlgorithms in server-sig-algs = " + String.valueOf(_known));
                }
                if (!_unknown.isEmpty() && session.getLogger().isEnabled(0)) {
                    session.getLogger().log(0, "PubkeyAcceptedAlgorithms not in server-sig-algs = " + String.valueOf(_unknown));
                }
                if (!_known.isEmpty() && !_unknown.isEmpty()) {
                    boolean success = this._start(session, identities, _known, not_available_pks);
                    if (success) {
                        return true;
                    }
                    return this._start(session, identities, _unknown, not_available_pks);
                }
            } else if (session.getLogger().isEnabled(0)) {
                session.getLogger().log(0, "No server-sig-algs found, using PubkeyAcceptedAlgorithms = " + String.valueOf(pkmethods));
            }
            return this._start(session, identities, pkmethods, not_available_pks);
        }
    }

    private boolean _start(Session session, List<Identity> identities, List<String> pkmethods, List<String> not_available_pks) throws Exception {
        if (session.auth_failures >= session.max_auth_tries) {
            return false;
        }
        boolean use_pk_auth_query = session.getConfig("enable_pubkey_auth_query").equals("yes");
        boolean try_other_pkmethods = session.getConfig("try_additional_pubkey_algorithms").equals("yes");
        ArrayList<String> rsamethods = new ArrayList<String>();
        ArrayList<String> nonrsamethods = new ArrayList<String>();
        for (String pkmethod : pkmethods) {
            if (pkmethod.equals("ssh-rsa") || pkmethod.equals("rsa-sha2-256") || pkmethod.equals("rsa-sha2-512") || pkmethod.equals("ssh-rsa-sha224@ssh.com") || pkmethod.equals("ssh-rsa-sha256@ssh.com") || pkmethod.equals("ssh-rsa-sha384@ssh.com") || pkmethod.equals("ssh-rsa-sha512@ssh.com")) {
                rsamethods.add(pkmethod);
                continue;
            }
            nonrsamethods.add(pkmethod);
        }
        byte[] _username = Util.str2byte(this.username);
        block1: for (Identity identity : identities) {
            if (session.auth_failures >= session.max_auth_tries) {
                return false;
            }
            this.decryptKey(session, identity);
            String _ipkmethod = identity.getAlgName();
            ArrayList<String> ipkmethods = null;
            if (_ipkmethod.equals("ssh-rsa")) {
                ipkmethods = new ArrayList<String>(rsamethods);
            } else if (nonrsamethods.contains(_ipkmethod)) {
                ipkmethods = new ArrayList(1);
                ipkmethods.add(_ipkmethod);
            }
            if (ipkmethods == null || ipkmethods.isEmpty()) {
                if (!session.getLogger().isEnabled(0)) continue;
                session.getLogger().log(0, _ipkmethod + " cannot be used as public key type for identity " + identity.getName());
                continue;
            }
            while (!ipkmethods.isEmpty() && session.auth_failures < session.max_auth_tries) {
                Iterator it;
                int command;
                byte[] pubkeyblob = identity.getPublicKeyBlob();
                ArrayList<String> pkmethodsuccesses = null;
                if (pubkeyblob != null && use_pk_auth_query) {
                    command = 51;
                    it = ipkmethods.iterator();
                    block3: while (it.hasNext()) {
                        String ipkmethod = (String)it.next();
                        it.remove();
                        if (not_available_pks.contains(ipkmethod) && !(identity instanceof AgentIdentity)) {
                            if (!session.getLogger().isEnabled(0)) continue;
                            session.getLogger().log(0, ipkmethod + " not available for identity " + identity.getName());
                            continue;
                        }
                        this.packet.reset();
                        this.buf.putByte((byte)50);
                        this.buf.putString(_username);
                        this.buf.putString(Util.str2byte("ssh-connection"));
                        this.buf.putString(Util.str2byte("publickey"));
                        this.buf.putByte((byte)0);
                        this.buf.putString(Util.str2byte(ipkmethod));
                        this.buf.putString(pubkeyblob);
                        session.write(this.packet);
                        while (true) {
                            this.buf = session.read(this.buf);
                            command = this.buf.getCommand() & 0xFF;
                            if (command == 60) {
                                if (session.getLogger().isEnabled(0)) {
                                    session.getLogger().log(0, ipkmethod + " preauth success");
                                }
                                pkmethodsuccesses = new ArrayList(1);
                                pkmethodsuccesses.add(ipkmethod);
                                break block3;
                            }
                            if (command == 51) {
                                if (!session.getLogger().isEnabled(0)) continue block3;
                                session.getLogger().log(0, ipkmethod + " preauth failure");
                                continue block3;
                            }
                            if (command != 53) break;
                            this.buf.getInt();
                            this.buf.getByte();
                            this.buf.getByte();
                            byte[] _message = this.buf.getString();
                            byte[] lang = this.buf.getString();
                            String message = Util.byte2str(_message);
                            if (this.userinfo == null) continue;
                            this.userinfo.showMessage(message);
                        }
                        if (!session.getLogger().isEnabled(0)) continue;
                        session.getLogger().log(0, ipkmethod + " preauth failure command (" + command + ")");
                    }
                    if (command != 60) continue block1;
                }
                if (identity.isEncrypted()) continue block1;
                if (pubkeyblob == null) {
                    pubkeyblob = identity.getPublicKeyBlob();
                }
                if (pubkeyblob == null) continue block1;
                if (pkmethodsuccesses == null) {
                    pkmethodsuccesses = ipkmethods;
                }
                if (pkmethodsuccesses.isEmpty()) continue block1;
                it = pkmethodsuccesses.iterator();
                while (it.hasNext() && session.auth_failures < session.max_auth_tries) {
                    String pkmethodsuccess = (String)it.next();
                    it.remove();
                    if (not_available_pks.contains(pkmethodsuccess) && !(identity instanceof AgentIdentity)) {
                        if (!session.getLogger().isEnabled(0)) continue;
                        session.getLogger().log(0, pkmethodsuccess + " not available for identity " + identity.getName());
                        continue;
                    }
                    this.packet.reset();
                    this.buf.putByte((byte)50);
                    this.buf.putString(_username);
                    this.buf.putString(Util.str2byte("ssh-connection"));
                    this.buf.putString(Util.str2byte("publickey"));
                    this.buf.putByte((byte)1);
                    this.buf.putString(Util.str2byte(pkmethodsuccess));
                    this.buf.putString(pubkeyblob);
                    byte[] sid = session.getSessionId();
                    int sidlen = sid.length;
                    byte[] tmp = new byte[4 + sidlen + this.buf.index - 5];
                    tmp[0] = (byte)(sidlen >>> 24);
                    tmp[1] = (byte)(sidlen >>> 16);
                    tmp[2] = (byte)(sidlen >>> 8);
                    tmp[3] = (byte)sidlen;
                    System.arraycopy(sid, 0, tmp, 4, sidlen);
                    System.arraycopy(this.buf.buffer, 5, tmp, 4 + sidlen, this.buf.index - 5);
                    byte[] signature = identity.getSignature(tmp, pkmethodsuccess);
                    if (signature == null) {
                        if (!session.getLogger().isEnabled(0)) continue;
                        session.getLogger().log(0, pkmethodsuccess + " signature failure");
                        continue;
                    }
                    this.buf.putString(signature);
                    session.write(this.packet);
                    while (true) {
                        this.buf = session.read(this.buf);
                        command = this.buf.getCommand() & 0xFF;
                        if (command == 52) {
                            if (session.getLogger().isEnabled(0)) {
                                session.getLogger().log(0, pkmethodsuccess + " auth success");
                            }
                            return true;
                        }
                        if (command != 53) break;
                        this.buf.getInt();
                        this.buf.getByte();
                        this.buf.getByte();
                        byte[] _message = this.buf.getString();
                        byte[] lang = this.buf.getString();
                        String message = Util.byte2str(_message);
                        if (this.userinfo == null) continue;
                        this.userinfo.showMessage(message);
                    }
                    if (command == 51) {
                        this.buf.getInt();
                        this.buf.getByte();
                        this.buf.getByte();
                        byte[] foo = this.buf.getString();
                        int partial_success = this.buf.getByte();
                        if (partial_success != 0) {
                            throw new JSchPartialAuthException(Util.byte2str(foo));
                        }
                        ++session.auth_failures;
                        if (session.getLogger().isEnabled(0)) {
                            session.getLogger().log(0, pkmethodsuccess + " auth failure");
                        }
                        if (session.auth_failures >= session.max_auth_tries) {
                            return false;
                        }
                        if (!try_other_pkmethods) continue block1;
                        continue;
                    }
                    if (!session.getLogger().isEnabled(0)) continue;
                    session.getLogger().log(0, pkmethodsuccess + " auth failure command (" + command + ")");
                }
            }
        }
        return false;
    }

    private void decryptKey(Session session, Identity identity) throws JSchException {
        byte[] passphrase = null;
        int count = 5;
        do {
            if (identity.isEncrypted() && passphrase == null) {
                if (this.userinfo == null) {
                    throw new JSchException("USERAUTH fail");
                }
                if (identity.isEncrypted() && !this.userinfo.promptPassphrase("Passphrase for " + identity.getName())) {
                    throw new JSchAuthCancelException("publickey");
                }
                String _passphrase = this.userinfo.getPassphrase();
                if (_passphrase != null) {
                    passphrase = Util.str2byte(_passphrase);
                }
            }
            if ((!identity.isEncrypted() || passphrase != null) && identity.setPassphrase(passphrase)) {
                if (passphrase == null || !(session.getIdentityRepository() instanceof IdentityRepositoryWrapper)) break;
                ((IdentityRepositoryWrapper)session.getIdentityRepository()).check();
                break;
            }
            Util.bzero(passphrase);
            passphrase = null;
        } while (--count != 0);
        Util.bzero(passphrase);
        passphrase = null;
    }
}

